
clear all
clc


run rev2_1  %change to rev2_2 to use the alternative calibration also change lambda below to .25
save('Results','var1','theta1','par0','otherpar0','parmatch0','R1','T1','S1')
clear all; %save and reload all the results from BT used next
load('Results')

%%% Description of "Results"
% 1. Matrix var1 containing all the equilibrium values for the BT model.
% This matrix is passed straight to most functions used subsequently.
% 2. Labor market tightness for the 3 aggr states
% 3-6. Parameters used in the BT calibration
% 7.-9.% The cutoffs for each aggr state: R for endogeneous blowup; T for the level above which a
% vacancy is retained; S for the level below which ojs happens.
%%%

% Transition Matrix Note: this is not exactly the matrix used in the BT
% paper but the one used in their code. It differs only slightly
phi = .9165;
psi = .01675;
gamma = 0.067;
t13 = 1-phi-gamma;
trans = [ 0    gamma     t13 ;   psi     0      psi ;   t13     gamma     0  ]   ;
pi = [ 1-gamma-t13    gamma     t13 ;   psi     1-2*psi      psi ;   t13     gamma     1-gamma-t13  ]   ;
cumul_pi=cumsum(pi,2);



% Parameters

b=0 %change this to .9 to get income losses
r=0.01
beta=0.5
sigma=1
a=1.71
gridsteps=200
lambda=0.15 %change this for the alternative calibration

pfind=parmatch0(1)*theta1.^(parmatch0(2)); %gives job finding rates for each aggregate state
pfindojs=a*parmatch0(1)*theta1.^(parmatch0(2)); %ojs finding rate

%% the next block computes all the relevant objects used for the simulations below.
% the structure is as follows. create a grid across the entire productivity
% space. assign wages and the distributions of vacancies and existing jobs
% and compute the position of the thresholds R S and T
for p=1:3 %p indexes the state
    
    for i=1:gridsteps
        prod(i)=-sigma+i*2*sigma/gridsteps; %grid across productivity
        w(i,:)=wage(prod(i),par0,parmatch0,var1);%wage grid
        cdfRT=RJL_FERT(prod(i),par0,parmatch0,var1);
        cdfTS=RJL_FETS(prod(i),par0,parmatch0,var1);
        cdfSsig=RJL_FESsig(prod(i),par0,parmatch0,var1);
        vcdfTS=FVTS(prod(i),par0,parmatch0,var1);
        vcdfSsig=RJL_FVSsig(prod(i),par0,parmatch0,var1);
        %these distributions are computed over the whole range of
        %productivity. now we have to assign them to the right ranges
        if prod(i)<=R1(p)
            vcdf(i,p)=0;
            cdf(i,p)=0;
        else if prod(i)<T1(p) & prod(i)>R1(p)
                vcdf(i,p)=0;
                cdf(i,p)=cdfRT(p);
            else if prod(i)>T1(p) & prod(i)<=S1(p)
                    cdf(i,p)=cdfTS(p);
                    vcdf(i,p)=vcdfTS(p);
                else if prod(i)>S1(p)
                        vcdf(i,p)=vcdfSsig(p);
                        cdf(i,p)=cdfSsig(p);
                    else
                    end
                end
            end
        end
    end
end

%just compute a pdf from the cdfs
for p=1:3
    vpdf(1,p)=vcdf(1,p);
    pdf(1,p)=cdf(1,p);
    for i=2:gridsteps
        pdf(i,p)=(cdf(i,p)-cdf(i-1,p));
        vpdf(i,p)=vcdf(i,p)-vcdf(i-1,p);
    end
end

Rcount=zeros(3,1)
Scount=zeros(3,1)
Tcount=zeros(3,1)
for p=1:3
    for i=1:gridsteps
        if prod(i)<R1(p)
            Rcount(p)=Rcount(p)+1;
        end
        if prod(i)<T1(p)
            Tcount(p)=Tcount(p)+1;
        end
        if prod(i)<S1(p)
            Scount(p)=Scount(p)+1;
        end
    end
end

for p=1:3
    for i=1:gridsteps
        if Rcount(p)>=i
            newpdf(i,p)=0;
        else
            newpdf(i,p)=1/(gridsteps-Rcount(p)+1);
        end
    end
end

% Computes values for assigning a terminal value
for p=1:3
    for i=1:gridsteps
        Mall=M(prod(i),par0,parmatch0,var1); %surplus for each idiosyncratic productivity level
        surplus(i,p)=Mall(p); %assigns the right surplus
    end
end

U=ones(gridsteps,1)*(Uvalue(par0,parmatch0,var1))';%Unemployment value for each aggregate state
E=beta.*surplus+U;% use Nash bargain to back out value of employment

%% the actual simulations
% run 2000 simulations of 80 quarters for each initial aggregate state 

for p=1:3 %aggregate state
    clearvars checkr state flows ojs eps flows looseifgm losses looseifgb draw_i looseifmb find_ojs find_s shock loss_idio keep loss_endo flows still_unemp first_job
    NSim=2000;
    T=80;% number of periods ie 20 years
    act=(gridsteps-(Rcount(p))) %nr of active gridpoints in state p
    e_i=act*100 %number of initially employed
    u_i=1000 %number of unemployed
    Nworkers= e_i+u_i
    
    for nn=1:NSim
        % Generate AGGREGATE sample productivity paths
        
        innov_productivity = rand(T,1);
        agg_state(1)=p;
        for t = 2:T
            check = innov_productivity(t,:) > cumul_pi(agg_state(t-1),:);
            agg_state(t,1) = sum(check) + 1;
        end
        
        % Generate sample path of job finding probabilities
        sample_f = pfind(agg_state);
        sample_f_ojs=pfindojs(agg_state);
        
        %Initialize
        state(1,1:Nworkers)=zeros;
        flows(1,1:Nworkers)=b;
        ojs(1,1:Nworkers)=0;
        %assign the initially employed a wage and a productivity
        state(1,1:e_i)=ones(1,e_i);
        for i=1:act
            draw_i((i-1)*100+1:i*100)=gridsteps-act+i; %assign 100 workers to each active gridstep
        end
        eps(1,1:Nworkers)=ones(1,1:Nworkers);
        eps(1,1:e_i)=draw_i; %eps indexes the position on the gird for each employed worker
        ojs(1,1:e_i)=prod(eps(1,1:e_i))<S1(p); %assign ojs
        flows(1,1:e_i)=w(draw_i,p)';
        
        % Generate sample paths for workers' states
        e_s=rand(T,Nworkers);
        e_ojs =rand(T,Nworkers);
        s1=rand(T,Nworkers);
        s2=-1+2*rand(T,Nworkers);
        first_job(1,Nworkers)=zeros;
        for t=2:T
            ojs(t-1,:)=prod(eps(t-1,:))<S1(agg_state(t-1)) & state(t-1,:)==1;
            find_ojs(t-1,:)=e_ojs(t-1,:)<sample_f_ojs(t) & ojs(t-1,:)==1;
            find_s(t-1,:)=e_s(t-1,:)<sample_f(t) & state(t-1,:)==0;
            shock(t-1,:)=s1(t-1,:)<lambda & state(t-1,:)==1; %workers get shocks
            loss_idio(t-1,:)=shock(t-1,:)==1 & s2(t-1,:)<R1(agg_state(t)) & (ojs(t-1,:)==0 | (ojs(t-1,:)==1 & find_ojs(t-1,:)==0)); %conditional on shock loose job or keep and update prod
            keep(t-1,:)=shock(t-1,:)==1 & s2(t-1,:)>R1(agg_state(t)) & (ojs(t-1,:)==0 | (ojs(t-1,:)==1 & find_ojs(t-1,:)==0));
            
            eps(t,:)=keep(t-1,:).*discretesample(newpdf(:,agg_state(t)),Nworkers)+...%update position on the prod grid
                find_s(t-1,:).*discretesample(vpdf(:,agg_state(t)),Nworkers)+...
                find_ojs(t-1,:).*discretesample(vpdf(:,agg_state(t)),Nworkers)+...
                (1-find_s(t-1,:)).*(1-keep(t-1,:)).*(1-find_ojs(t-1,:)).*eps(t-1,:);
            
            
            loss_endo(t-1,:)=state(t-1,:)==1 & loss_idio(t-1,:)==0 & prod(eps(t,:))<R1(agg_state(t));%check for endogenous destruction
            state(t,:) = 0 + state(t-1,:).*(1-loss_idio(t-1,:)).*(1-loss_endo(t-1,:))+...%update state
                (1-state(t-1,:)).*find_s(t-1,:);
            flows(t,:)=(1-state(t,:)).*b+...%-ojs(t-1,:)*0.1*(1+r)+...%compute flows
                state(t,:).*w(eps(t,:),agg_state(t,:))';
            %the next part generates a dummy when the initally unemployed
            %find their first job
            if t==2
                still_unemp(t-1,:)=state(t-1,:);
            else
                still_unemp(t-1,:)=sum(state(1:t-1,:));
            end
            
            first_job(t,:)=state(t,:)==1 & still_unemp(t-1,:)==0;
            
        end
        
        discount = ones(T,1)*1/(1+r);
        discount_matrix = (1+r)*cumprod(discount)*ones(1,Nworkers); % matrix of discount factors
        PDV_flows = discount_matrix.*flows(1:T,:);
        PDV_total = sum(PDV_flows);
        % last_asset_value = state(T,:).*(E(eps(T,:),agg_state(T)))' + (1-state(T,:)).*(U(eps(T,:),agg_state(T)))';
        PDV_total = PDV_total %+ (1+r)^(-T)*last_asset_value; %assigning terminal value
        Un(nn,p)=(mean(PDV_total(Nworkers-999:Nworkers))); %computes the mean PDV of the unemployed
        
        for i=1:act
            for n=1:100
                losses_ind(n)=1-Un(nn,p)./(PDV_total((i-1)*100+n));
            end
            losses(i)=mean(losses_ind);%for each group of workers computes the mean losses
        end
        
        av_losses(nn,p)=losses*pdf(gridsteps-act+1:gridsteps,p); %weights the groups
        
       
        %the rest of the nn loop computes objects needed below
        
        gmloss=Rcount(2)-Rcount(1); %number of gridpoints at which workers loose job when agg state changes from 1 to 2
        gbloss=Rcount(3)-Rcount(1);
        mbloss=Rcount(3)-Rcount(2);
        if p==1
            for i=1:gmloss
                gm(i)=mean(PDV_total((i-1)*100+1:i*100)); %mean PDV of workers in state 1 who loose job when aggstate changes to 2
            end
            for i=1:gbloss
                gb(i)=mean(PDV_total((i-1)*100+i:i*100));
            end
            pdvgm(nn,:)=gm; %save the means of the gridpoints for each simulation
            pdvgb(nn,:)=gb;
        end
        
        if p==2
            for i=1:mbloss
                mb(i)=mean(PDV_total((i-1)*100+1:i*100));
            end
            pdvmb(nn,:)=mb;
        end
        
        %         av_wage(nn,p)=mean(flows(1,1:e_i));
        first_wage=sum(first_job.*flows); %creates a vector of first wages
        first_wage_av(nn,p)=mean(first_wage(e_i+1:Nworkers)); %mean first wage (of the initially unemployed)
        
        %stores the means for each gridpoint
        if p==1
            for i=1:act
                gvalue(i)=mean(PDV_total((i-1)*100+1:i*100));
            end
            pdvg(nn,:)=gvalue;
        end
        
        if p==2
            for i=1:act
                mvalue(i)=mean(PDV_total((i-1)*100+1:i*100));
            end
            pdvm(nn,:)=mvalue;
        end
        
    end
    
end


%computations

%panel A

losses_exogenous=mean(av_losses) %across simulations

%comnpute Panel C take the losses for each gridpoint (computed by the value
%of unemployment in new state relative to a counterfactual unemployment in
%old state and then weight
for nn=1:NSim
    loss_idio_gm(nn)=  (1-Un(nn,2)./pdvg(nn,:))*pdf(Rcount(1)+1:gridsteps,1)
    loss_idio_gb(nn)=  (1-Un(nn,3)./pdvg(nn,:))*pdf(Rcount(1)+1:gridsteps,1)
    loss_idio_mb(nn)=  (1-Un(nn,3)./pdvm(nn,:))*pdf(Rcount(2)+1:gridsteps,1)
end

PanelC(1)=mean(loss_idio_gm)
PanelC(2)=mean(loss_idio_mb)
PanelC(3)=mean(loss_idio_gb)

% computes Panel D analogously to Panel C
for nn=1:NSim
    loss_endo_gm(nn)=  (1-Un(nn,2)./pdvgm(nn,:))*pdf(Rcount(1)+1:Rcount(2),1)./(sum(pdf(Rcount(1)+1:Rcount(2),1)))
    loss_endo_gb(nn)=  (1-Un(nn,3)./pdvgb(nn,:))*pdf(Rcount(1)+1:Rcount(3),1)./(sum(pdf(Rcount(1)+1:Rcount(3),1)))
    loss_endo_mb(nn)=   (1-Un(nn,3)./pdvmb(nn,:))*pdf(Rcount(2)+1:Rcount(3),1)./(sum(pdf(Rcount(2)+1:Rcount(3),1)))
end

PanelD(1)=mean(loss_endo_gm)
PanelD(2)=mean(loss_endo_mb)
PanelD(3)=mean(loss_endo_gb)

% compute the ratio of old wage to mean new wage for each old wage and then
% weight by the distribution of wages old

for p=1:3
    earnings_diff(p)=[1-(mean(first_wage_av(:,p)))./w(:,p)]'*(pdf(:,p))
end

earnings_diff_gm=[1-(mean(first_wage_av(:,2)))./w(:,1)]'*(pdf(:,1))
earnings_diff_mb=[1-(mean(first_wage_av(:,3)))./w(:,2)]'*(pdf(:,2))
earnings_diff_gb=[1-(mean(first_wage_av(:,3)))./w(:,1)]'*(pdf(:,1))


%% the next part just produces the graph in the appendix

hl1=plot(prod,pdf(:,1),'r');
hold;
hl2=plot(prod,vpdf(:,1),'--r');
ax1 = gca;
set(ax1,'YColor','r','YAxisLocation','left','box','off','XTick',[R1(1) T1(1) S1(1)],'XTickLabel',{'R(p)','T(p) ',' S(p)'})
Xlabel('Idiosyncratic Productivity')
Ylabel('Density')
ax2 = axes('Position',get(ax1,'Position'),...
    'YAxisLocation','right',...
    'Color','none',...
    'XColor','k','YColor','k','XTick',[-1 0 1]);
hold
hl3 = plot(prod,w(:,1).*[1./zeros(Rcount(1),1);ones(gridsteps-Rcount(1),1)],'Color','k','Parent',ax2,'LineWidth',2);
Ylabel('wage')
Title({'Wages and Match Distribution across productivities - BT calibration',''})

plot(prod, zeros)
